/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

  FIVe3D v2.0  -  2008-04-14
  Flash Interactive Vector-based 3D
  Mathieu Badimon  |  five3d.mathieu-badimon.com  |  www.mathieu-badimon.com  |  contact@mathieu-badimon.com

/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

package org.papervision3d.typography.fonts {
	import org.papervision3d.typography.Font3D;		

	public class HelveticaBold extends Font3D{

		static public var __motifs:Object = {};
		static public var __widths:Object = {};
		static public var __height:Number = 119;
		static public var __initialized:Boolean = false;

		static public function initialize():void {
			initializeMotifsUppercase();
			initializeMotifsLowercase();
			initializeMotifsNumbers();
			initializeMotifsPunctuation();
			initializeWidthsUppercase();
			initializeWidthsLowercase();
			initializeWidthsNumbers();
			initializeWidthsPunctuation();
			__initialized = true;
		}
		
		////////////////////////////////////////////
		override public function get motifs():Object
		{
			if(!__initialized)initialize();
			return __motifs;
		}

		override public function get widths():Object
		{
			if(!__initialized)initialize();
			return __widths;
		}
		
		override public function get height():Number
		{ 
			if(!__initialized)initialize();
			return __height;
		}
		////////////////////////////////////////////

		static private function initializeMotifsUppercase():void {
			__motifs["A"] = [['M',[34.4,43.75]],['L',[43.35,69.9]],['L',[24.85,69.9]],['L',[34.2,43.75]],['L',[34.4,43.75]],['M',[20.8,81.65]],['L',[47.45,81.65]],['L',[52.9,97.5]],['L',[69.2,97.5]],['L',[42.5,26.1]],['L',[26.35,26.1]],['L',[-0.75,97.5]],['L',[15.2,97.5]],['L',[20.8,81.65]]];
			__motifs["B"] = [['M',[48.1,46.5]],['C',[48,50.95,45.35,53]],['C',[42.7,55.05,38.5,55]],['L',[22.6,55]],['L',[22.6,38.3]],['L',[37.3,38.3]],['C',[40.15,38.25,42.6,38.95]],['C',[45,39.6,46.55,41.35]],['C',[48.05,43.15,48.1,46.5]],['M',[40.5,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[41.5,97.5]],['C',[48.05,97.5,53.75,95.35]],['C',[59.45,93.2,63.05,88.6]],['C',[66.6,84,66.7,76.8]],['C',[66.7,70.05,63.4,65.35]],['C',[60.1,60.65,53.55,58.75]],['C',[58.25,56.5,60.75,52.75]],['C',[63.25,49.05,63.3,43.85]],['C',[63.25,37.2,60.4,33.35]],['C',[57.55,29.45,52.45,27.75]],['C',[47.35,26.05,40.5,26.1]],['M',[22.6,65.7]],['L',[39.7,65.7]],['C',[44.8,65.65,47.85,68.05]],['C',[50.95,70.5,51,75.9]],['C',[50.95,79.6,49.35,81.65]],['C',[47.75,83.7,45.15,84.5]],['C',[42.55,85.35,39.4,85.3]],['L',[22.6,85.3]],['L',[22.6,65.7]]];
			__motifs["C"] = [['M',[51.75,43.7]],['C',[53.95,46.5,54.55,50.1]],['L',[69.75,50.1]],['C',[68.7,41.85,64.4,36.1]],['C',[60.05,30.35,53.45,27.4]],['C',[46.9,24.4,38.9,24.4]],['C',[27.85,24.5,20,29.5]],['C',[12.15,34.4,8,42.9]],['C',[3.85,51.4,3.8,62.1]],['C',[3.85,72.55,8,80.9]],['C',[12.15,89.25,20,94.2]],['C',[27.85,99.1,38.9,99.2]],['C',[47.7,99.15,54.5,95.6]],['C',[61.25,92.05,65.4,85.5]],['C',[69.5,78.95,70.3,70]],['L',[55.15,70]],['C',[54.25,77.2,50.2,81.55]],['C',[46.15,85.95,38.9,86.05]],['C',[31.9,85.95,27.65,82.45]],['C',[23.35,79.05,21.45,73.6]],['C',[19.5,68.15,19.55,62.1]],['C',[19.5,55.75,21.45,50.2]],['C',[23.35,44.6,27.65,41.15]],['C',[31.9,37.7,38.9,37.6]],['C',[42.85,37.65,46.2,39.25]],['C',[49.55,40.85,51.75,43.7]]];
			__motifs["D"] = [['M',[54.35,30]],['C',[47,26.1,37.7,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[37.7,97.5]],['C',[48.6,97.4,55.8,92.75]],['C',[63,88.1,66.55,79.95]],['C',[70.1,71.85,70.1,61.4]],['C',[70,49.55,65.8,41.75]],['C',[61.6,33.9,54.35,30]],['M',[33.8,39.3]],['C',[41.55,39.35,46.1,42.25]],['C',[50.6,45.1,52.55,50.4]],['C',[54.45,55.65,54.4,62.95]],['C',[54.35,70.8,51.8,75.5]],['C',[49.3,80.2,45.25,82.25]],['C',[41.2,84.35,36.6,84.3]],['L',[22.6,84.3]],['L',[22.6,39.3]],['L',[33.8,39.3]]];
			__motifs["E"] = [['M',[60.3,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[61.1,97.5]],['L',[61.1,84.3]],['L',[22.6,84.3]],['L',[22.6,66.8]],['L',[57.2,66.8]],['L',[57.2,54.6]],['L',[22.6,54.6]],['L',[22.6,39.3]],['L',[60.3,39.3]],['L',[60.3,26.1]]];
			__motifs["F"] = [['M',[57.1,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[22.6,97.5]],['L',[22.6,68]],['L',[52.5,68]],['L',[52.5,55.8]],['L',[22.6,55.8]],['L',[22.6,39.3]],['L',[57.1,39.3]],['L',[57.1,26.1]]];
			__motifs["G"] = [['M',[52.85,27.35]],['C',[46.35,24.4,38.9,24.4]],['C',[27.85,24.5,20,29.5]],['C',[12.15,34.4,8,42.9]],['C',[3.85,51.4,3.8,62.1]],['C',[3.85,72.55,8,80.9]],['C',[12.15,89.25,20,94.2]],['C',[27.85,99.1,38.9,99.2]],['C',[44.15,99.25,49.2,96.95]],['C',[54.35,94.65,58.5,89.45]],['L',[60.1,97.5]],['L',[70.1,97.5]],['L',[70.1,58.9]],['L',[40.15,58.9]],['L',[40.15,70.6]],['L',[55.9,70.6]],['C',[55.2,78.05,50.9,82]],['C',[46.6,86,38.9,86.05]],['C',[31.9,85.95,27.65,82.45]],['C',[23.35,79.05,21.45,73.6]],['C',[19.5,68.15,19.55,62.1]],['C',[19.5,55.75,21.45,50.2]],['C',[23.35,44.6,27.65,41.15]],['C',[31.9,37.7,38.9,37.6]],['C',[44.55,37.6,48.6,40.6]],['C',[52.6,43.65,54,49.6]],['L',[69,49.6]],['C',[68.05,41.5,63.7,35.9]],['C',[59.35,30.25,52.85,27.35]]];
			__motifs["H"] = [['M',[51.45,26.1]],['L',[51.45,53.5]],['L',[22.6,53.5]],['L',[22.6,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[22.6,97.5]],['L',[22.6,66.7]],['L',[51.45,66.7]],['L',[51.45,97.5]],['L',[67.2,97.5]],['L',[67.2,26.1]],['L',[51.45,26.1]]];
			__motifs["I"] = [['M',[6.9,26.1]],['L',[6.9,97.5]],['L',[22.6,97.5]],['L',[22.6,26.1]],['L',[6.9,26.1]]];
			__motifs["J"] = [['M',[15.65,70.95]],['L',[1.4,70.95]],['L',[1.4,77.15]],['C',[1.5,84.9,4.9,89.8]],['C',[8.2,94.65,13.55,96.95]],['C',[18.85,99.2,24.9,99.2]],['C',[32.85,99.1,37.65,96.7]],['C',[42.4,94.35,44.8,90.55]],['C',[47.2,86.8,48,82.7]],['C',[48.8,78.55,48.75,75.05]],['L',[48.75,26.1]],['L',[33,26.1]],['L',[33,74.3]],['C',[33.1,76.9,32.7,79.6]],['C',[32.3,82.25,30.55,84.1]],['C',[28.8,85.95,24.7,86.05]],['C',[21.05,86,19.1,84.45]],['C',[17.1,82.95,16.35,80.25]],['C',[15.6,77.65,15.65,74.1]],['L',[15.65,70.95]]];
			__motifs["K"] = [['M',[50.5,26.1]],['L',[22.6,55.7]],['L',[22.6,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[22.6,97.5]],['L',[22.6,74.5]],['L',[31.6,65.4]],['L',[53.1,97.5]],['L',[72.8,97.5]],['L',[42.2,54.3]],['L',[70.1,26.1]],['L',[50.5,26.1]]];
			__motifs["L"] = [['M',[6.9,26.1]],['L',[6.9,97.5]],['L',[57.4,97.5]],['L',[57.4,84.3]],['L',[22.6,84.3]],['L',[22.6,26.1]],['L',[6.9,26.1]]];
			__motifs["M"] = [['M',[83.8,26.1]],['L',[61.65,26.1]],['L',[45.9,75.2]],['L',[45.7,75.2]],['L',[29,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[21.6,97.5]],['L',[21.6,47.4]],['L',[21.8,47.4]],['L',[39.3,97.5]],['L',[51.35,97.5]],['L',[68.9,46.9]],['L',[69.1,46.9]],['L',[69.1,97.5]],['L',[83.8,97.5]],['L',[83.8,26.1]]];
			__motifs["N"] = [['M',[52.5,26.1]],['L',[52.5,74]],['L',[52.3,74]],['L',[22.45,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[21.6,97.5]],['L',[21.6,49.7]],['L',[21.8,49.7]],['L',[51.5,97.5]],['L',[67.2,97.5]],['L',[67.2,26.1]],['L',[52.5,26.1]]];
			__motifs["O"] = [['M',[57.8,29.5]],['C',[50,24.5,38.9,24.4]],['C',[27.85,24.5,20,29.5]],['C',[12.15,34.4,8,42.9]],['C',[3.85,51.4,3.8,62.1]],['C',[3.85,72.55,8,80.9]],['C',[12.15,89.25,20,94.2]],['C',[27.85,99.1,38.9,99.2]],['C',[50,99.1,57.8,94.2]],['C',[65.65,89.25,69.8,80.9]],['C',[73.95,72.55,74,62.1]],['C',[73.95,51.4,69.8,42.9]],['C',[65.65,34.4,57.8,29.5]],['M',[38.9,37.6]],['C',[45.95,37.7,50.2,41.15]],['C',[54.5,44.6,56.4,50.2]],['C',[58.35,55.75,58.3,62.1]],['C',[58.35,68.15,56.4,73.6]],['C',[54.5,79.05,50.2,82.45]],['C',[45.95,85.95,38.9,86.05]],['C',[31.9,85.95,27.65,82.45]],['C',[23.35,79.05,21.45,73.6]],['C',[19.5,68.15,19.55,62.1]],['C',[19.5,55.75,21.45,50.2]],['C',[23.35,44.6,27.65,41.15]],['C',[31.9,37.7,38.9,37.6]]];
			__motifs["P"] = [['M',[48.6,49]],['C',[48.55,53.5,46.65,55.85]],['C',[44.75,58.15,41.6,58.95]],['L',[34.8,59.7]],['L',[22.6,59.7]],['L',[22.6,38.3]],['L',[34.8,38.3]],['C',[38.5,38.25,41.6,39.05]],['C',[44.75,39.9,46.65,42.2]],['C',[48.55,44.5,48.6,49]],['M',[53.35,29.5]],['C',[47.95,26.2,39.1,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[22.6,97.5]],['L',[22.6,71.9]],['L',[39.1,71.9]],['C',[47.95,71.8,53.35,68.55]],['C',[58.85,65.25,61.35,60.1]],['C',[63.8,54.9,63.75,49]],['C',[63.8,43.1,61.35,37.95]],['C',[58.85,32.75,53.35,29.5]]];
			__motifs["Q"] = [['M',[57.8,29.5]],['C',[50,24.5,38.9,24.4]],['C',[27.85,24.5,20,29.5]],['C',[12.15,34.4,8,42.9]],['C',[3.85,51.4,3.8,62.1]],['C',[3.85,72.55,8,80.9]],['C',[12.15,89.25,20,94.2]],['C',[27.85,99.1,38.9,99.2]],['C',[43.95,99.2,48.3,98.15]],['C',[52.7,97.05,56.2,95]],['L',[66.3,104.2]],['L',[73.65,96.5]],['L',[64.7,88.4]],['C',[69.25,83.3,71.65,76.6]],['C',[73.95,69.85,74,62.1]],['C',[73.95,51.4,69.8,42.9]],['C',[65.65,34.4,57.8,29.5]],['M',[38.9,37.6]],['C',[45.95,37.7,50.2,41.15]],['C',[54.5,44.6,56.4,50.2]],['C',[58.35,55.75,58.3,62.1]],['C',[58.3,67.65,57.1,71.7]],['C',[55.9,75.8,53.9,78.5]],['L',[45.8,71.15]],['L',[38.55,78.95]],['L',[45.2,85.05]],['C',[44.35,85.75,42.55,85.9]],['L',[38.9,86.05]],['C',[31.9,85.95,27.65,82.45]],['C',[23.35,79.05,21.45,73.6]],['C',[19.5,68.15,19.55,62.1]],['C',[19.5,55.75,21.45,50.2]],['C',[23.35,44.6,27.65,41.15]],['C',[31.9,37.7,38.9,37.6]]];
			__motifs["R"] = [['M',[50.6,48.2]],['C',[50.6,53.55,47.8,56]],['C',[45.05,58.45,39.8,58.4]],['L',[22.6,58.4]],['L',[22.6,38.3]],['L',[39.8,38.3]],['C',[45.05,38.25,47.8,40.65]],['C',[50.6,43.05,50.6,48.2]],['M',[45.4,26.1]],['L',[6.9,26.1]],['L',[6.9,97.5]],['L',[22.6,97.5]],['L',[22.6,69.55]],['L',[38.3,69.55]],['C',[44.15,69.5,46.8,72.15]],['C',[49.45,74.8,50.2,80.35]],['L',[51.05,89.4]],['C',[51.35,94,52.7,97.5]],['L',[68.35,97.5]],['C',[67,95.4,66.4,92.3]],['C',[65.8,89.25,65.65,86.05]],['L',[65.4,80.55]],['C',[65.2,76.95,64.15,73.5]],['C',[63.2,70.05,61,67.45]],['C',[58.8,64.95,55,63.85]],['L',[55,63.65]],['C',[60.9,61.25,63.6,56.7]],['C',[66.35,52.15,66.3,45.8]],['C',[66.25,40.35,63.7,35.95]],['C',[61.2,31.5,56.5,28.85]],['C',[51.8,26.15,45.4,26.1]]];
			__motifs["S"] = [['M',[45.55,26.7]],['C',[39.05,24.35,31.5,24.4]],['C',[26.6,24.4,21.9,25.7]],['C',[17.15,27.05,13.3,29.75]],['C',[9.4,32.4,7.15,36.45]],['C',[4.85,40.5,4.8,46]],['C',[4.9,52.65,7.95,56.6]],['C',[11.05,60.6,15.85,62.8]],['C',[20.65,65,26.05,66.3]],['L',[36.3,68.9]],['C',[41.05,70.15,44.15,72.25]],['C',[47.2,74.3,47.3,78.1]],['C',[47.2,81.75,44.9,83.7]],['C',[42.7,85.6,39.45,86.3]],['C',[36.3,87.05,33.4,87]],['C',[29.15,87,25.55,85.7]],['C',[21.95,84.35,19.8,81.45]],['C',[17.65,78.55,17.6,73.8]],['L',[2.4,73.8]],['C',[2.4,80.4,4.85,85.2]],['C',[7.3,90,11.55,93.1]],['C',[15.85,96.25,21.35,97.7]],['C',[26.8,99.2,32.8,99.2]],['C',[42.55,99.15,49.1,96.2]],['C',[55.7,93.2,59.15,88.1]],['C',[62.5,82.9,62.5,76.3]],['C',[62.4,70.25,59.9,66.4]],['C',[57.4,62.55,53.85,60.35]],['C',[50.25,58.1,46.85,57]],['L',[41.3,55.5]],['L',[27.8,51.9]],['C',[23.15,50.5,21.55,48.9]],['C',[19.85,47.35,19.95,44.7]],['C',[20,41.75,21.7,39.95]],['C',[23.3,38.15,25.8,37.4]],['C',[28.2,36.6,30.8,36.6]],['C',[34.55,36.55,37.7,37.5]],['C',[40.75,38.4,42.7,40.75]],['C',[44.65,43.15,44.9,47.4]],['L',[60.1,47.4]],['C',[60,39.2,56,34.1]],['C',[52,29.05,45.55,26.7]]];
			__motifs["T"] = [['M',[59.8,26.1]],['L',[1.3,26.1]],['L',[1.3,39.3]],['L',[22.7,39.3]],['L',[22.7,97.5]],['L',[38.45,97.5]],['L',[38.45,39.3]],['L',[59.8,39.3]],['L',[59.8,26.1]]];
			__motifs["U"] = [['M',[51.8,26.1]],['L',[51.8,70.55]],['C',[51.85,75.8,50.5,79.25]],['C',[49.05,82.7,45.85,84.35]],['C',[42.6,86.05,37,86.05]],['C',[30.75,86,27.55,83.75]],['C',[24.35,81.55,23.3,78]],['C',[22.2,74.5,22.3,70.55]],['L',[22.3,26.1]],['L',[6.6,26.1]],['L',[6.6,70.55]],['C',[6.7,85.05,14.6,92.15]],['C',[22.5,99.2,37,99.2]],['C',[51.45,99.2,59.4,92.1]],['C',[67.4,85,67.55,70.55]],['L',[67.55,26.1]],['L',[51.8,26.1]]];
			__motifs["V"] = [['M',[47.6,26.1]],['L',[31.5,76.3]],['L',[31.3,76.3]],['L',[15.45,26.1]],['L',[-0.8,26.1]],['L',[22.4,97.5]],['L',[40.15,97.5]],['L',[63.8,26.1]],['L',[47.6,26.1]]];
			__motifs["W"] = [['M',[47.2,48.9]],['L',[59.3,97.5]],['L',[74.9,97.5]],['L',[94.1,26.1]],['L',[78.7,26.1]],['L',[67,75.3]],['L',[66.8,75.3]],['L',[54.6,26.1]],['L',[39.9,26.1]],['L',[27.5,74.7]],['L',[27.3,74.7]],['L',[16,26.1]],['L',[0.3,26.1]],['L',[19.2,97.5]],['L',[35.1,97.5]],['L',[47,48.9]],['L',[47.2,48.9]]];
			__motifs["X"] = [['M',[48.15,26.1]],['L',[33.65,48.9]],['L',[19.65,26.1]],['L',[1.4,26.1]],['L',[24.4,60.1]],['L',[-0.6,97.5]],['L',[17.15,97.5]],['L',[33,72.8]],['L',[48.65,97.5]],['L',[67.35,97.5]],['L',[42.45,60.2]],['L',[65.35,26.1]],['L',[48.15,26.1]]];
			__motifs["Y"] = [['M',[50.1,26.1]],['L',[33.5,54.3]],['L',[16.8,26.1]],['L',[-0.9,26.1]],['L',[25.4,69.7]],['L',[25.4,97.5]],['L',[41.1,97.5]],['L',[41.1,70.1]],['L',[67.65,26.1]],['L',[50.1,26.1]]];
			__motifs["Z"] = [['M',[61.5,26.1]],['L',[5.3,26.1]],['L',[5.3,39.3]],['L',[40.6,39.3]],['L',[2.3,85.1]],['L',[2.3,97.5]],['L',[62.5,97.5]],['L',[62.5,84.3]],['L',[23.2,84.3]],['L',[61.5,38.5]],['L',[61.5,26.1]]];
		}

		static private function initializeMotifsLowercase():void {
			__motifs["a"] = [['M',[17.8,45.9]],['C',[12.45,47.5,8.9,51.3]],['C',[5.3,55.05,4.8,61.7]],['L',[19,61.65]],['C',[19.4,57.5,21.85,55.7]],['C',[24.3,53.85,28.35,53.9]],['L',[33,54.35]],['C',[35.05,54.8,36.35,56.35]],['C',[37.55,57.85,37.6,60.9]],['C',[37.55,63.7,35.15,64.95]],['C',[32.8,66.15,29,66.65]],['L',[20.8,67.65]],['C',[16.3,68.2,12.3,69.65]],['C',[8.3,71.15,5.75,74.35]],['C',[3.25,77.6,3.15,83.4]],['C',[3.2,88.7,5.55,92.15]],['C',[7.9,95.6,11.85,97.25]],['C',[15.8,98.9,20.8,98.9]],['C',[25.6,98.95,30.2,97.45]],['C',[34.75,96,38.2,92.5]],['L',[38.55,95.05]],['L',[39.2,97.5]],['L',[53.6,97.5]],['C',[52.65,95.85,52.2,92.7]],['C',[51.8,89.6,51.8,86]],['L',[51.8,59.05]],['C',[51.75,54.5,49.7,51.55]],['C',[47.65,48.65,44.35,47.05]],['C',[40.95,45.5,37,44.9]],['L',[29.1,44.4]],['C',[23.2,44.35,17.8,45.9]],['M',[37.6,72.15]],['L',[37.6,77.5]],['L',[37.35,80.65]],['C',[37.1,82.6,36.05,84.6]],['C',[34.9,86.6,32.55,88]],['C',[30.2,89.35,26.05,89.4]],['C',[22.5,89.5,20,88.1]],['C',[17.5,86.7,17.4,82.8]],['C',[17.5,79,19.9,77.4]],['C',[22.35,75.75,25.8,75.2]],['L',[32.4,74.15]],['C',[35.7,73.65,37.6,72.15]]];
			__motifs["b"] = [['M',[5.4,26.1]],['L',[5.4,97.5]],['L',[18.95,97.5]],['L',[18.95,90.9]],['L',[19.15,90.9]],['C',[21.5,95.15,25.95,97.05]],['C',[30.35,98.95,36.15,98.9]],['C',[41.35,98.9,46.25,96.05]],['C',[51.1,93.2,54.25,87.15]],['C',[57.4,81.1,57.5,71.55]],['C',[57.4,62.15,54.25,56.15]],['C',[51.1,50.1,46.25,47.2]],['C',[41.35,44.4,36.15,44.4]],['C',[31.25,44.4,26.9,46.25]],['C',[22.55,48.15,19.8,52.1]],['L',[19.65,52.1]],['L',[19.65,26.1]],['L',[5.4,26.1]],['M',[38.1,57.45]],['C',[40.75,59.75,42.05,63.5]],['C',[43.3,67.3,43.3,71.7]],['C',[43.3,76.05,42.05,79.8]],['C',[40.75,83.55,38.1,85.9]],['C',[35.4,88.15,31.2,88.2]],['C',[27.05,88.15,24.35,85.9]],['C',[21.7,83.55,20.4,79.8]],['C',[19.1,76.05,19.15,71.7]],['C',[19.1,67.3,20.4,63.5]],['C',[21.7,59.75,24.35,57.45]],['C',[27.05,55.1,31.2,55.05]],['C',[35.4,55.1,38.1,57.45]]];
			__motifs["c"] = [['M',[15.9,48.05]],['C',[10,51.65,6.95,57.95]],['C',[3.85,64.25,3.8,72.4]],['C',[3.85,80.2,7.15,86.15]],['C',[10.35,92.15,16.2,95.5]],['C',[22.05,98.85,29.95,98.9]],['C',[40.25,98.85,46.8,93.45]],['C',[53.35,88.05,54.85,77.7]],['L',[41.1,77.7]],['C',[40.45,82.5,37.6,85.35]],['C',[34.75,88.15,29.85,88.2]],['C',[25.4,88.15,22.8,85.65]],['C',[20.2,83.15,19.1,79.45]],['C',[17.95,75.7,18,71.9]],['C',[17.95,68,19.15,64.15]],['C',[20.25,60.3,22.95,57.75]],['C',[25.6,55.15,30.15,55.05]],['C',[34.55,55.05,37.25,57.35]],['C',[39.95,59.6,40.65,64]],['L',[54.5,64]],['C',[53.95,57.35,50.55,53]],['C',[47.05,48.65,41.75,46.5]],['C',[36.4,44.4,30.2,44.4]],['C',[21.8,44.45,15.9,48.05]]];
			__motifs["d"] = [['M',[41.6,26.1]],['L',[41.6,52.1]],['L',[41.4,52.1]],['C',[38.9,48.3,34.8,46.35]],['C',[30.75,44.4,26.1,44.4]],['C',[18.5,44.5,13.45,48.3]],['C',[8.3,52,5.75,58.1]],['C',[3.2,64.15,3.2,71.2]],['C',[3.15,78.45,5.75,84.75]],['C',[8.3,91,13.45,94.9]],['C',[18.6,98.75,26.4,98.9]],['C',[31.4,98.9,35.5,97]],['C',[39.55,95.05,42.1,90.9]],['L',[42.3,90.9]],['L',[42.3,97.5]],['L',[55.8,97.5]],['L',[55.8,26.1]],['L',[41.6,26.1]],['M',[37.15,57.45]],['C',[39.85,59.8,40.95,63.5]],['C',[42.15,67.25,42.1,71.5]],['C',[42.15,75.8,41,79.65]],['C',[39.9,83.4,37.25,85.8]],['C',[34.55,88.15,29.9,88.2]],['C',[25.55,88.15,22.75,85.7]],['C',[19.95,83.3,18.7,79.5]],['C',[17.4,75.7,17.4,71.6]],['C',[17.4,67.3,18.55,63.55]],['C',[19.8,59.8,22.5,57.5]],['C',[25.3,55.15,29.9,55.1]],['C',[34.45,55.15,37.15,57.45]]];
			__motifs["e"] = [['M',[15.5,48]],['C',[9.5,51.55,6.25,57.7]],['C',[2.95,63.85,2.9,71.65]],['C',[2.95,79.8,6.1,85.9]],['C',[9.3,92,15.2,95.4]],['C',[21.1,98.85,29.3,98.9]],['C',[38.1,98.95,44.3,94.75]],['C',[50.45,90.6,53.45,81.5]],['L',[40.95,81.5]],['C',[40.25,84,37.2,86.05]],['C',[34.15,88.15,29.8,88.2]],['C',[23.85,88.25,20.6,85.05]],['C',[17.4,81.85,17.1,75.1]],['L',[54.4,75.1]],['C',[54.75,69.1,53.35,63.55]],['C',[51.95,58.1,48.85,53.75]],['C',[45.65,49.45,40.75,46.95]],['C',[35.9,44.4,29.3,44.4]],['C',[21.4,44.45,15.5,48]],['M',[40.2,66.1]],['L',[17.1,66.1]],['C',[17.15,64,18.2,61.45]],['C',[19.35,58.95,21.9,57]],['C',[24.4,55.15,28.9,55.05]],['C',[34,55.05,36.6,57.85]],['C',[39.25,60.7,40.2,66.1]]];
			__motifs["f"] = [['M',[0,45.8]],['L',[0,55.3]],['L',[8.5,55.3]],['L',[8.5,97.5]],['L',[22.7,97.5]],['L',[22.7,55.3]],['L',[32.5,55.3]],['L',[32.5,45.8]],['L',[22.7,45.8]],['L',[22.7,42.7]],['C',[22.7,39.5,23.95,38.15]],['C',[25.3,36.75,28.15,36.8]],['L',[30.75,36.85]],['L',[33.3,37.1]],['L',[33.3,26.5]],['L',[29.6,26.25]],['L',[25.8,26.1]],['C',[20,26.15,16.15,28.15]],['C',[12.3,30.15,10.4,33.7]],['C',[8.5,37.2,8.5,41.8]],['L',[8.5,45.8]],['L',[0,45.8]]];
			__motifs["g"] = [['M',[41.6,45.8]],['L',[41.6,52.7]],['L',[41.4,52.7]],['C',[38.85,48.25,34.95,46.3]],['C',[31.1,44.35,26.05,44.4]],['C',[18.75,44.45,13.8,48.05]],['C',[8.9,51.6,6.35,57.35]],['C',[3.8,63.15,3.8,69.95]],['C',[3.8,77.2,6.1,83.05]],['C',[8.4,88.9,13.3,92.4]],['C',[18.15,95.9,25.95,96]],['C',[30.65,96,34.8,94.05]],['C',[38.95,92.05,41.4,88]],['L',[41.6,88]],['L',[41.6,94.75]],['C',[41.7,100.45,38.9,104]],['C',[36.15,107.5,30.2,107.6]],['C',[26.35,107.65,23.55,106.05]],['C',[20.65,104.45,19.65,100.5]],['L',[5.5,100.5]],['C',[6,106.4,9.45,110.05]],['C',[12.95,113.7,18,115.4]],['C',[23.1,117.15,28.3,117.15]],['C',[37.15,117.05,42.55,114.75]],['C',[47.9,112.45,50.6,108.85]],['C',[53.3,105.25,54.25,101.35]],['C',[55.15,97.45,55.1,94.2]],['L',[55.1,45.8]],['L',[41.6,45.8]],['M',[36.7,57.3]],['C',[39.4,59.5,40.55,63.15]],['C',[41.65,66.75,41.6,71]],['C',[41.6,74.75,40.3,77.95]],['C',[38.9,81.25,36.25,83.25]],['C',[33.55,85.25,29.5,85.3]],['C',[25.2,85.2,22.65,82.9]],['C',[20.1,80.6,19.05,77.1]],['C',[17.95,73.55,18,69.75]],['C',[18,65.85,19.25,62.55]],['C',[20.4,59.2,23,57.15]],['C',[25.55,55.1,29.5,55.05]],['C',[34.1,55.1,36.7,57.3]]];
			__motifs["h"] = [['M',[5.4,26.1]],['L',[5.4,97.5]],['L',[19.65,97.5]],['L',[19.65,70.35]],['C',[19.6,62.55,22.2,59]],['C',[24.85,55.5,30.6,55.55]],['C',[35.5,55.55,37.65,58.75]],['C',[39.75,61.9,39.7,68.25]],['L',[39.7,97.5]],['L',[53.9,97.5]],['L',[53.9,65.65]],['C',[53.95,59.2,52.35,54.45]],['C',[50.75,49.7,46.65,47.05]],['C',[42.5,44.4,35,44.4]],['C',[30.9,44.4,26.8,46.45]],['C',[22.75,48.6,19.9,52.95]],['L',[19.65,52.95]],['L',[19.65,26.1]],['L',[5.4,26.1]]];
			__motifs["i"] = [['M',[20,26.1]],['L',[5.8,26.1]],['L',[5.8,37.85]],['L',[20,37.85]],['L',[20,26.1]],['M',[5.8,45.8]],['L',[5.8,97.5]],['L',[20,97.5]],['L',[20,45.8]],['L',[5.8,45.8]]];
			__motifs["j"] = [['M',[20.9,26.1]],['L',[6.7,26.1]],['L',[6.7,37.85]],['L',[20.9,37.85]],['L',[20.9,26.1]],['M',[6.7,45.8]],['L',[6.7,99.4]],['C',[6.65,102.25,5.05,103.15]],['C',[3.4,104.1,1.15,104]],['L',[-0.5,103.9]],['L',[-1.9,103.6]],['L',[-1.9,115.3]],['L',[0.4,115.55]],['L',[2.7,115.7]],['C',[9.75,115.7,13.75,114]],['C',[17.75,112.35,19.35,108.9]],['C',[20.95,105.4,20.9,100.1]],['L',[20.9,45.8]],['L',[6.7,45.8]]];
			__motifs["k"] = [['M',[6.7,26.1]],['L',[6.7,97.5]],['L',[20.9,97.5]],['L',[20.9,79.75]],['L',[26.4,74.4]],['L',[40.6,97.5]],['L',[57.8,97.5]],['L',[36.1,64.8]],['L',[55.6,45.8]],['L',[38.8,45.8]],['L',[20.9,64.4]],['L',[20.9,26.1]],['L',[6.7,26.1]]];
			__motifs["l"] = [['M',[5.8,26.1]],['L',[5.8,97.5]],['L',[20,97.5]],['L',[20,26.1]],['L',[5.8,26.1]]];
			__motifs["m"] = [['M',[82.4,52.15]],['C',[80,48.05,75.75,46.2]],['C',[71.5,44.35,65.95,44.4]],['C',[60.55,44.45,56.55,46.95]],['C',[52.6,49.45,50.35,52.95]],['C',[48.15,48.4,44.2,46.35]],['C',[40.2,44.35,35.25,44.4]],['C',[30.2,44.4,26.2,46.55]],['C',[22.2,48.75,19.45,52.75]],['L',[19.25,52.75]],['L',[19.25,45.8]],['L',[5.8,45.8]],['L',[5.8,97.5]],['L',[20,97.5]],['L',[20,67.5]],['C',[20.1,62.5,21.9,59.9]],['C',[23.65,57.3,25.9,56.4]],['C',[28.15,55.5,29.65,55.55]],['C',[34.05,55.6,35.85,57.55]],['C',[37.7,59.5,38,62.45]],['C',[38.35,65.35,38.25,68.45]],['L',[38.25,97.5]],['L',[52.45,97.5]],['L',[52.45,68.7]],['C',[52.4,65.35,53.15,62.4]],['C',[53.85,59.4,55.9,57.5]],['C',[58,55.6,61.95,55.55]],['C',[65.9,55.6,67.8,57.25]],['C',[69.7,58.95,70.2,61.8]],['C',[70.7,64.7,70.65,68.15]],['L',[70.65,97.5]],['L',[84.85,97.5]],['L',[84.85,62.9]],['C',[84.8,56.2,82.4,52.15]]];
			__motifs["n"] = [['M',[5.4,45.8]],['L',[5.4,97.5]],['L',[19.65,97.5]],['L',[19.65,70.4]],['C',[19.6,62.55,22.2,59]],['C',[24.85,55.5,30.6,55.55]],['C',[35.5,55.55,37.65,58.75]],['C',[39.75,61.9,39.7,68.25]],['L',[39.7,97.5]],['L',[53.9,97.5]],['L',[53.9,65.65]],['C',[53.95,59.2,52.35,54.45]],['C',[50.75,49.7,46.65,47.05]],['C',[42.5,44.4,35,44.4]],['C',[30.4,44.4,26.2,46.45]],['C',[22,48.6,19.25,52.95]],['L',[18.95,52.95]],['L',[18.95,45.8]],['L',[5.4,45.8]]];
			__motifs["o"] = [['M',[16.4,47.8]],['C',[10.4,51.15,7.15,57.25]],['C',[3.85,63.35,3.8,71.7]],['C',[3.85,79.95,7.15,86.05]],['C',[10.4,92.15,16.4,95.5]],['C',[22.35,98.85,30.5,98.9]],['C',[38.7,98.85,44.75,95.5]],['C',[50.75,92.15,54,86.05]],['C',[57.3,79.95,57.3,71.7]],['C',[57.3,63.35,54,57.25]],['C',[50.75,51.15,44.75,47.8]],['C',[38.7,44.4,30.5,44.4]],['C',[22.35,44.4,16.4,47.8]],['M',[30.5,55.05]],['C',[35.35,55.15,38.1,57.5]],['C',[40.85,59.9,42,63.7]],['C',[43.15,67.45,43.1,71.7]],['C',[43.15,75.85,42,79.65]],['C',[40.85,83.4,38.1,85.8]],['C',[35.35,88.15,30.5,88.2]],['C',[25.75,88.15,23,85.8]],['C',[20.25,83.4,19.15,79.65]],['C',[17.95,75.85,18,71.7]],['C',[17.95,67.45,19.15,63.7]],['C',[20.25,59.9,23,57.5]],['C',[25.75,55.15,30.5,55.05]]];
			__motifs["p"] = [['M',[5.4,45.8]],['L',[5.4,115.7]],['L',[19.65,115.7]],['L',[19.65,91.1]],['L',[19.8,91.1]],['C',[22.45,94.95,26.5,96.9]],['C',[30.6,98.9,35.3,98.9]],['C',[42.85,98.8,47.9,95.05]],['C',[52.95,91.3,55.45,85.25]],['C',[58,79.25,58,72.2]],['C',[58,64.75,55.5,58.45]],['C',[53.05,52.15,47.8,48.35]],['C',[42.6,44.45,34.5,44.4]],['C',[29.7,44.4,25.7,46.35]],['C',[21.75,48.3,19.15,52.4]],['L',[18.95,52.4]],['L',[18.95,45.8]],['L',[5.4,45.8]],['M',[38.65,57.55]],['C',[41.4,60,42.65,63.8]],['C',[43.85,67.55,43.8,71.75]],['C',[43.85,76.05,42.7,79.8]],['C',[41.55,83.55,38.8,85.85]],['C',[36.15,88.15,31.5,88.2]],['C',[26.95,88.15,24.2,85.85]],['C',[21.5,83.55,20.3,79.8]],['C',[19.1,76.05,19.15,71.8]],['C',[19.1,67.5,20.25,63.7]],['C',[21.4,59.9,24.1,57.5]],['C',[26.8,55.1,31.4,55.05]],['C',[35.95,55.15,38.65,57.55]]];
			__motifs["q"] = [['M',[42.3,45.8]],['L',[42.3,52.4]],['L',[42.1,52.4]],['C',[39.6,48.15,35.45,46.25]],['C',[31.3,44.35,26.35,44.4]],['C',[18.55,44.45,13.4,48.4]],['C',[8.25,52.25,5.7,58.55]],['C',[3.15,64.8,3.15,72]],['C',[3.2,79.5,5.25,84.65]],['C',[7.3,89.85,10.55,92.95]],['C',[13.85,96.15,17.7,97.5]],['C',[21.5,98.9,25.1,98.9]],['C',[28.2,98.9,31.35,98.1]],['C',[34.45,97.3,37.1,95.55]],['C',[39.7,93.8,41.4,91]],['L',[41.6,91]],['L',[41.6,115.7]],['L',[55.8,115.7]],['L',[55.8,45.8]],['L',[42.3,45.8]],['M',[37.1,57.6]],['C',[39.75,60.1,40.95,63.9]],['C',[42.15,67.75,42.1,71.9]],['C',[42.15,76.2,40.9,79.9]],['C',[39.75,83.65,37,85.9]],['C',[34.3,88.15,29.7,88.2]],['C',[25.05,88.15,22.35,85.8]],['C',[19.7,83.45,18.5,79.7]],['C',[17.35,75.9,17.4,71.7]],['C',[17.35,67.4,18.6,63.65]],['C',[19.8,59.85,22.6,57.5]],['C',[25.4,55.1,30,55.05]],['C',[34.4,55.15,37.1,57.6]]];
			__motifs["r"] = [['M',[5.4,45.8]],['L',[5.4,97.5]],['L',[19.65,97.5]],['L',[19.65,74.2]],['C',[19.6,69.55,20.95,65.8]],['C',[22.3,62.05,25.4,59.85]],['C',[28.45,57.6,33.65,57.55]],['L',[36.35,57.7]],['L',[38.7,58.05]],['L',[38.7,44.85]],['L',[37.2,44.5]],['L',[35.65,44.4]],['C',[32.15,44.4,28.85,45.8]],['C',[25.6,47.15,23.05,49.65]],['C',[20.45,52.1,19.15,55.35]],['L',[18.95,55.35]],['L',[18.95,45.8]],['L',[5.4,45.8]]];
			__motifs["s"] = [['M',[15.8,45.75]],['C',[10.75,47.2,7.45,50.8]],['C',[4.2,54.45,4.1,61]],['C',[4.2,65.45,6.55,68.2]],['C',[8.9,70.95,12.6,72.45]],['C',[16.3,73.9,20.5,74.8]],['C',[28.15,76.35,32.35,78]],['C',[36.5,79.7,36.55,82.8]],['C',[36.5,85.3,35.05,86.75]],['C',[33.65,88.15,31.5,88.8]],['L',[27.3,89.4]],['C',[24.45,89.4,22,88.5]],['C',[19.6,87.65,18,85.75]],['C',[16.5,83.8,16.4,80.7]],['L',[2.95,80.7]],['C',[3.3,87.5,6.85,91.5]],['C',[10.3,95.5,15.7,97.25]],['C',[21.1,98.95,27.2,98.9]],['C',[33.2,98.95,38.55,97.25]],['C',[43.9,95.6,47.25,91.65]],['C',[50.7,87.65,50.8,80.9]],['C',[50.7,76.15,48.4,73.3]],['C',[46.05,70.45,42.35,68.9]],['C',[38.6,67.3,34.4,66.4]],['L',[26.6,64.7]],['C',[23,63.85,20.65,62.55]],['C',[18.35,61.15,18.3,58.7]],['C',[18.35,56.65,19.65,55.55]],['C',[20.9,54.55,22.75,54.2]],['L',[26.2,53.9]],['C',[30.15,53.8,32.8,55.3]],['C',[35.5,56.85,35.9,60.9]],['L',[49.35,60.9]],['C',[48.75,54.6,45.45,50.95]],['C',[42.25,47.35,37.25,45.85]],['C',[32.3,44.35,26.6,44.4]],['C',[20.95,44.35,15.8,45.75]]];
			__motifs["t"] = [['M',[23.4,30.3]],['L',[9.2,30.3]],['L',[9.2,45.8]],['L',[0.6,45.8]],['L',[0.6,55.3]],['L',[9.2,55.3]],['L',[9.2,85.85]],['C',[9.25,90.9,11.45,93.55]],['C',[13.7,96.25,17.4,97.2]],['C',[21.1,98.15,25.5,98.1]],['L',[29.8,98]],['L',[33.8,97.6]],['L',[33.8,86.5]],['L',[31.6,86.8]],['L',[29.4,86.9]],['C',[25.9,87,24.55,85.7]],['C',[23.3,84.4,23.4,80.9]],['L',[23.4,55.3]],['L',[33.8,55.3]],['L',[33.8,45.8]],['L',[23.4,45.8]],['L',[23.4,30.3]]];
			__motifs["u"] = [['M',[5.4,45.8]],['L',[5.4,77.65]],['C',[5.35,84.05,7,88.85]],['C',[8.6,93.6,12.7,96.25]],['C',[16.85,98.85,24.3,98.9]],['C',[28.9,98.9,33.1,96.8]],['C',[37.3,94.65,40.1,90.3]],['L',[40.4,90.3]],['L',[40.4,97.5]],['L',[53.9,97.5]],['L',[53.9,45.8]],['L',[39.7,45.8]],['L',[39.7,72.9]],['C',[39.75,80.75,37.1,84.25]],['C',[34.45,87.8,28.7,87.75]],['C',[23.85,87.75,21.7,84.55]],['C',[19.6,81.4,19.65,75.05]],['L',[19.65,45.8]],['L',[5.4,45.8]]];
			__motifs["v"] = [['M',[0.5,45.8]],['L',[18.15,97.5]],['L',[34,97.5]],['L',[51.45,45.8]],['L',[37.35,45.8]],['L',[26.45,81.1]],['L',[26.25,81.1]],['L',[15.4,45.8]],['L',[0.5,45.8]]];
			__motifs["w"] = [['M',[66.2,45.8]],['L',[56.75,80.8]],['L',[56.5,80.8]],['L',[47.7,45.8]],['L',[33.9,45.8]],['L',[25.3,80.9]],['L',[25.1,80.9]],['L',[15.6,45.8]],['L',[0.6,45.8]],['L',[17,97.5]],['L',[31.7,97.5]],['L',[40.5,62.8]],['L',[40.7,62.8]],['L',[49.9,97.5]],['L',[64.5,97.5]],['L',[80.8,45.8]],['L',[66.2,45.8]]];
			__motifs["x"] = [['M',[1.6,45.8]],['L',[18.6,70.3]],['L',[0,97.5]],['L',[15.9,97.5]],['L',[26.7,81.2]],['L',[37.5,97.5]],['L',[53.7,97.5]],['L',[34.6,70]],['L',[51.6,45.8]],['L',[35.9,45.8]],['L',[26.9,59.3]],['L',[17.8,45.8]],['L',[1.6,45.8]]];
			__motifs["y"] = [['M',[18.1,98.55]],['C',[17.85,100.65,16.5,102.2]],['C',[15.15,103.7,12.7,104]],['L',[8.55,103.85]],['L',[4.4,103.5]],['L',[4.4,115.2]],['L',[8.75,115.55]],['L',[13.1,115.7]],['C',[20.35,115.75,24.5,113]],['C',[28.65,110.2,30.9,104]],['L',[52.5,45.8]],['L',[37.8,45.8]],['L',[26.5,81.2]],['L',[26.3,81.2]],['L',[14.6,45.8]],['L',[-0.6,45.8]],['L',[17.65,94.3]],['C',[18.4,96.45,18.1,98.55]]];
			__motifs["z"] = [['M',[2.2,97.5]],['L',[49.7,97.5]],['L',[49.7,86.8]],['L',[20.9,86.8]],['L',[47.8,56.5]],['L',[47.8,45.8]],['L',[4.2,45.8]],['L',[4.2,56.5]],['L',[29.1,56.5]],['L',[2.2,86.8]],['L',[2.2,97.5]]];
		}

		static private function initializeMotifsNumbers():void {
			__motifs["0"] = [['M',[40.65,29.45]],['C',[34.8,26,27.7,26.1]],['C',[20.7,26,14.95,29.45]],['C',[9.15,32.8,5.65,40.7]],['C',[2.2,48.65,2.1,62.2]],['C',[2.2,76.05,5.65,84.1]],['C',[9.15,92.2,14.95,95.6]],['C',[20.7,99,27.7,98.9]],['C',[34.8,99,40.65,95.6]],['C',[46.45,92.2,49.95,84.1]],['C',[53.4,76.05,53.5,62.2]],['C',[53.4,48.65,49.95,40.7]],['C',[46.45,32.8,40.65,29.45]],['M',[37.85,47.3]],['C',[38.9,51.25,39.1,55.3]],['L',[39.3,62.2]],['L',[39.1,69.45]],['C',[38.9,73.6,37.85,77.7]],['C',[36.8,81.75,34.4,84.4]],['C',[32.05,87.1,27.7,87.2]],['C',[23.5,87.1,21.1,84.4]],['C',[18.75,81.75,17.7,77.7]],['C',[16.7,73.6,16.5,69.45]],['C',[16.25,65.25,16.3,62.2]],['C',[16.25,59.35,16.5,55.3]],['C',[16.7,51.25,17.7,47.3]],['C',[18.75,43.3,21.1,40.6]],['C',[23.5,37.95,27.7,37.85]],['C',[32.05,37.95,34.4,40.6]],['C',[36.8,43.3,37.85,47.3]]];
			__motifs["1"] = [['M',[7.4,41.4]],['L',[7.4,52.1]],['L',[25,52.1]],['L',[25,97.5]],['L',[39.2,97.5]],['L',[39.2,27.5]],['L',[27.9,27.5]],['C',[27.1,32.8,24.1,35.9]],['C',[21.15,39,16.8,40.25]],['C',[12.4,41.55,7.4,41.4]]];
			__motifs["2"] = [['M',[41,28.75]],['C',[35.6,26.15,29.1,26.1]],['C',[20.7,26.2,14.95,29.9]],['C',[9.25,33.6,6.35,40]],['C',[3.45,46.35,3.7,54.45]],['L',[17.35,54.45]],['C',[17.3,50.65,18.35,46.95]],['C',[19.4,43.3,21.85,40.85]],['C',[24.25,38.4,28.4,38.3]],['C',[33.1,38.35,35.95,41.25]],['C',[38.8,44.15,38.9,49.1]],['C',[38.75,53.35,36.45,56.45]],['C',[34.15,59.5,30.75,61.8]],['L',[24.2,66.2]],['C',[18.1,70.2,13.15,74.35]],['C',[8.15,78.5,5.2,84]],['C',[2.25,89.5,2.1,97.5]],['L',[53.5,97.5]],['L',[53.5,85.3]],['L',[20.4,85.3]],['C',[23,81.75,26.4,79]],['C',[29.8,76.3,33.45,73.95]],['L',[40.65,69.2]],['C',[44.1,66.8,46.9,63.85]],['C',[49.75,60.95,51.4,57.05]],['C',[53.1,53.2,53.15,48]],['C',[53.05,41.15,49.75,36.25]],['C',[46.45,31.35,41,28.75]]];
			__motifs["3"] = [['M',[43.65,31.15]],['C',[40.25,28.65,36.1,27.4]],['C',[31.95,26.1,27.7,26.1]],['C',[20.45,26.15,15.15,29.25]],['C',[9.8,32.25,6.8,37.7]],['C',[3.8,43.15,3.5,50.35]],['L',[17,50.35]],['C',[16.95,44.8,19.7,41.4]],['C',[22.45,37.95,27.8,37.85]],['C',[30.4,37.85,32.65,38.9]],['C',[34.9,40.05,36.3,42.1]],['C',[37.65,44.2,37.7,47.15]],['C',[37.6,51.05,35.2,53]],['C',[32.8,55,29.4,55.55]],['L',[22.8,55.8]],['L',[22.8,65.8]],['L',[30.1,66.15]],['C',[33.8,66.6,36.35,68.8]],['C',[38.9,71,39,76.2]],['C',[38.9,81.25,35.7,84.15]],['C',[32.5,87.15,27.6,87.2]],['C',[23.5,87.15,20.8,85.3]],['C',[18.15,83.5,16.8,80.35]],['C',[15.45,77.25,15.3,73.45]],['L',[1.8,73.45]],['C',[1.7,81.5,4.95,87.15]],['C',[8.15,92.85,14,95.9]],['C',[19.85,98.85,27.8,98.9]],['C',[34.75,98.85,40.65,96.25]],['C',[46.55,93.55,50.1,88.4]],['C',[53.7,83.3,53.8,75.9]],['C',[53.75,69.95,50.5,65.7]],['C',[47.2,61.4,41.4,60.05]],['L',[41.4,59.85]],['C',[46.3,58.4,48.75,54.5]],['C',[51.15,50.6,51.15,45.55]],['C',[51.1,40.85,49.05,37.25]],['C',[47,33.6,43.65,31.15]]];
			__motifs["4"] = [['M',[31.2,45.3]],['L',[31.2,69.55]],['L',[12.8,69.55]],['L',[30.9,45.3]],['L',[31.2,45.3]],['M',[31.2,97.5]],['L',[44.7,97.5]],['L',[44.7,81.3]],['L',[53.95,81.3]],['L',[53.95,69.55]],['L',[44.7,69.55]],['L',[44.7,27.5]],['L',[32,27.5]],['L',[1.6,68.3]],['L',[1.6,81.3]],['L',[31.2,81.3]],['L',[31.2,97.5]]];
			__motifs["5"] = [['M',[50,27.5]],['L',[10.9,27.5]],['L',[4,66.2]],['L',[16.8,66.2]],['C',[18.85,63.3,21.3,61.95]],['C',[23.75,60.6,27.5,60.6]],['C',[31.3,60.65,34.05,62.35]],['C',[36.7,64.1,38.15,67.05]],['C',[39.6,70,39.6,73.65]],['C',[39.6,77.25,38.15,80.3]],['C',[36.6,83.4,33.95,85.25]],['C',[31.2,87.15,27.5,87.2]],['C',[22.8,87.15,19.7,84.25]],['C',[16.6,81.45,16,76.7]],['L',[1.8,76.7]],['C',[2,84.05,5.6,89]],['C',[9.25,93.95,15.05,96.45]],['C',[20.9,98.9,27.8,98.9]],['C',[34.95,98.95,40.8,95.7]],['C',[46.7,92.4,50.2,86.7]],['C',[53.7,81,53.8,73.65]],['C',[53.8,67.1,51.25,61.7]],['C',[48.75,56.35,43.95,53.15]],['C',[39.1,50,32.25,49.9]],['C',[28.1,49.85,24.7,51.1]],['C',[21.35,52.4,18.5,55.3]],['L',[18.3,55.05]],['L',[21.1,39.2]],['L',[50,39.2]],['L',[50,27.5]]];
			__motifs["6"] = [['M',[40.55,28.4]],['C',[35.7,26.1,29.6,26.1]],['C',[22.15,26.2,16.9,29.45]],['C',[11.65,32.65,8.4,38.05]],['C',[5.15,43.35,3.6,49.8]],['C',[2.1,56.25,2.1,62.75]],['C',[2.05,69.4,3.3,75.8]],['C',[4.6,82.25,7.6,87.45]],['C',[10.6,92.65,15.85,95.75]],['C',[21.1,98.8,29,98.9]],['C',[36.35,98.8,41.85,95.45]],['C',[47.35,92.1,50.4,86.3]],['C',[53.45,80.55,53.5,73.35]],['C',[53.5,69.15,52.2,65.1]],['C',[50.9,61,48.1,57.7]],['C',[45,54.4,40.8,52.5]],['C',[36.55,50.6,32,50.55]],['C',[26.9,50.5,23,52.4]],['C',[19.1,54.25,16.15,58.35]],['L',[15.95,58.15]],['C',[16.1,55.1,16.8,51.5]],['C',[17.5,47.9,19,44.5]],['C',[20.45,41.2,23,39.05]],['C',[25.55,36.85,29.4,36.8]],['C',[33.1,36.9,35.6,39.4]],['C',[38.1,41.9,38.8,45.5]],['L',[52.3,45.5]],['C',[51.45,39.35,48.4,35]],['C',[45.3,30.7,40.55,28.4]],['M',[28.6,61.2]],['C',[32.25,61.25,34.6,63.15]],['C',[37,65.1,38.15,68.05]],['C',[39.3,71.05,39.3,74.4]],['C',[39.3,77.65,38.05,80.5]],['C',[36.75,83.45,34.4,85.3]],['C',[32.05,87.15,28.6,87.2]],['C',[25.05,87.15,22.5,85.3]],['C',[19.95,83.45,18.65,80.45]],['C',[17.3,77.55,17.3,74.2]],['C',[17.3,70.7,18.5,67.75]],['C',[19.8,64.85,22.25,63.1]],['C',[24.8,61.25,28.6,61.2]]];
			__motifs["7"] = [['M',[51.7,27.5]],['L',[3.9,27.5]],['L',[3.9,40.65]],['L',[37.1,40.65]],['C',[27.05,52.75,21,67.3]],['C',[14.9,81.9,13.6,97.5]],['L',[28.8,97.5]],['C',[28.9,90.4,30.4,82.35]],['C',[31.95,74.35,34.8,66.4]],['C',[37.7,58.4,41.95,51.5]],['C',[46.2,44.55,51.7,39.7]],['L',[51.7,27.5]]];
			__motifs["8"] = [['M',[46.15,32.95]],['C',[43.4,30,38.9,28.05]],['C',[34.4,26.15,27.9,26.1]],['C',[22.05,26.1,16.7,28.25]],['C',[11.35,30.4,7.85,34.65]],['C',[4.45,38.9,4.3,45.2]],['C',[4.3,50.45,6.9,54.3]],['C',[9.45,58.1,14.6,59.6]],['L',[14.6,59.8]],['C',[8.4,61.35,4.95,65.8]],['C',[1.45,70.25,1.4,77]],['C',[1.5,84.5,5.25,89.4]],['C',[9.1,94.25,15.1,96.55]],['C',[21.15,98.9,28,98.9]],['C',[32.9,98.9,37.6,97.55]],['C',[42.25,96.2,46,93.4]],['C',[49.7,90.65,51.95,86.55]],['C',[54.15,82.4,54.2,76.9]],['C',[54.15,70.25,50.8,65.75]],['C',[47.35,61.25,41.1,59.8]],['L',[41.1,59.6]],['C',[46.05,57.9,48.7,54]],['C',[51.25,50.15,51.3,44.9]],['C',[51.3,42.3,50.1,39.1]],['C',[48.9,35.95,46.15,32.95]],['M',[18.7,41.25]],['C',[20.15,39.05,22.6,37.95]],['C',[25,36.8,27.9,36.8]],['C',[32.25,36.85,34.5,38.5]],['C',[36.8,40.15,37.65,42.35]],['C',[38.45,44.6,38.4,46.5]],['C',[38.3,51,35.3,53.35]],['C',[32.35,55.7,27.9,55.7]],['C',[25,55.7,22.6,54.7]],['C',[20.15,53.65,18.7,51.6]],['C',[17.25,49.55,17.2,46.5]],['C',[17.25,43.4,18.7,41.25]],['M',[28,65.2]],['C',[31.35,65.2,34.05,66.6]],['C',[36.75,68,38.4,70.5]],['C',[39.95,73.05,40,76.4]],['C',[39.9,81.75,36.55,84.9]],['C',[33.2,88.15,28,88.2]],['C',[24.55,88.15,21.8,86.7]],['C',[18.95,85.25,17.3,82.6]],['C',[15.65,79.9,15.6,76.3]],['C',[15.65,72.7,17.3,70.2]],['C',[18.95,67.75,21.75,66.5]],['C',[24.5,65.2,28,65.2]]];
			__motifs["9"] = [['M',[48,37.6]],['C',[45,32.35,39.75,29.3]],['C',[34.5,26.2,26.6,26.1]],['C',[19.3,26.2,13.75,29.6]],['C',[8.25,32.95,5.2,38.7]],['C',[2.15,44.45,2.1,51.7]],['C',[2.1,55.9,3.4,59.95]],['C',[4.75,64.05,7.5,67.3]],['C',[10.6,70.65,14.8,72.55]],['C',[19.05,74.45,23.65,74.5]],['C',[28.7,74.55,32.6,72.65]],['C',[36.5,70.8,39.45,66.7]],['L',[39.65,66.9]],['C',[39.5,69.9,38.8,73.55]],['C',[38.15,77.15,36.6,80.5]],['C',[35.15,83.85,32.6,86]],['C',[30.1,88.15,26.2,88.2]],['C',[22.5,88.15,20,85.65]],['C',[17.55,83.15,16.8,79.55]],['L',[3.3,79.55]],['C',[4.15,85.7,7.25,90.05]],['C',[10.3,94.35,15.1,96.6]],['C',[19.9,98.9,26.05,98.9]],['C',[33.45,98.8,38.7,95.6]],['C',[43.95,92.35,47.2,87]],['C',[50.5,81.7,52,75.25]],['C',[53.5,68.8,53.5,62.3]],['C',[53.55,55.6,52.3,49.2]],['C',[51.05,42.75,48,37.6]],['M',[36.95,44.55]],['C',[38.35,47.5,38.35,50.8]],['C',[38.35,54.35,37.1,57.25]],['C',[35.85,60.2,33.35,61.95]],['C',[30.8,63.75,27,63.8]],['C',[23.4,63.75,21,61.85]],['C',[18.6,59.95,17.5,56.95]],['C',[16.3,54,16.3,50.65]],['C',[16.3,47.4,17.6,44.5]],['C',[18.85,41.6,21.2,39.75]],['C',[23.6,37.9,27,37.85]],['C',[30.55,37.9,33.1,39.75]],['C',[35.65,41.6,36.95,44.55]]];
		}

		static private function initializeMotifsPunctuation():void {
			__motifs[" "] = [];
			__motifs["!"] = [['M',[21.3,26.1]],['L',[6.5,26.1]],['L',[6.5,45.3]],['L',[10.3,76.1]],['L',[17.4,76.1]],['L',[21.3,45.3]],['L',[21.3,26.1]],['M',[6.1,97.5]],['L',[21.85,97.5]],['L',[21.85,82.1]],['L',[6.1,82.1]],['L',[6.1,97.5]]];
			__motifs["\""] = [['M',[8.5,26.1]],['L',[8.5,58.2]],['L',[19.2,58.2]],['L',[19.2,26.1]],['L',[8.5,26.1]],['M',[27.1,26.1]],['L',[27.1,58.2]],['L',[37.8,58.2]],['L',[37.8,26.1]],['L',[27.1,26.1]]];
			__motifs["#"] = [['M',[47.6,27.55]],['L',[37.9,27.55]],['L',[35.2,47.3]],['L',[25.5,47.3]],['L',[28.25,27.55]],['L',[18.6,27.55]],['L',[15.75,47.3]],['L',[6.3,47.3]],['L',[6.3,56.3]],['L',[14.6,56.3]],['L',[12.8,68.7]],['L',[3.25,68.7]],['L',[3.25,77.7]],['L',[11.55,77.7]],['L',[8.8,97.45]],['L',[18.5,97.45]],['L',[21.3,77.7]],['L',[30.9,77.7]],['L',[28.15,97.45]],['L',[37.9,97.45]],['L',[40.6,77.7]],['L',[49.25,77.7]],['L',[49.25,68.7]],['L',[41.9,68.7]],['L',[43.6,56.3]],['L',[52.3,56.3]],['L',[52.3,47.3]],['L',[44.85,47.3]],['L',[47.6,27.55]],['M',[33.9,56.3]],['L',[32.2,68.7]],['L',[22.45,68.7]],['L',[24.25,56.3]],['L',[33.9,56.3]]];
			__motifs["$"] = [['M',[41.65,27.45]],['C',[36.7,25.05,30.7,24.4]],['L',[30.7,16.7]],['L',[24.8,16.7]],['L',[24.8,24.4]],['C',[18.7,24.75,13.5,27.25]],['C',[8.2,29.7,5,34.3]],['C',[1.7,38.95,1.6,45.8]],['C',[1.7,52.4,4.6,56.3]],['C',[7.45,60.2,11.95,62.3]],['C',[16.5,64.45,21.65,65.7]],['L',[23.45,66.15]],['L',[24.8,66.6]],['L',[24.8,87.55]],['C',[20.1,86.55,17.15,83.25]],['C',[14.15,79.85,14.1,74.3]],['L',[-0.1,74.3]],['C',[1.05,86.05,7.35,92.25]],['C',[13.65,98.4,24.8,99.2]],['L',[24.8,107.7]],['L',[30.7,107.7]],['L',[30.7,99.2]],['C',[38.15,98.6,43,96.2]],['C',[47.9,93.75,50.7,90.4]],['C',[53.45,87.05,54.6,83.8]],['C',[55.75,80.5,55.7,78.3]],['C',[55.75,75.75,55.3,72.6]],['C',[54.9,69.45,53.1,66.2]],['C',[51.2,63,47.15,60.05]],['C',[43.05,57.15,35.8,55.1]],['L',[33.2,54.45]],['L',[30.7,53.8]],['L',[30.7,36.1]],['C',[34.2,36.2,36.5,38.9]],['C',[38.85,41.65,39,45.7]],['L',[53.2,45.7]],['C',[52.75,38.85,49.65,34.35]],['C',[46.6,29.85,41.65,27.45]],['M',[17.15,39.85]],['C',[18.45,38,20.45,37.05]],['C',[22.5,36.1,24.8,36.1]],['L',[24.8,52.45]],['C',[20.05,51.35,17.9,49.5]],['C',[15.75,47.65,15.8,44.4]],['C',[15.85,41.65,17.15,39.85]],['M',[39.05,71.8]],['C',[41.55,73.85,41.5,77.7]],['C',[41.45,80.9,39.8,82.95]],['C',[38.15,85.05,35.7,86.15]],['C',[33.2,87.25,30.7,87.5]],['L',[30.7,68.3]],['C',[36.55,69.8,39.05,71.8]]];
			__motifs["%"] = [['M',[81.95,84.35]],['C',[81.55,87.15,80.15,89.25]],['C',[78.7,91.3,75.7,91.4]],['C',[72.55,91.3,71.2,89.2]],['C',[69.8,87.15,69.55,84.35]],['C',[69.25,81.6,69.3,79.3]],['C',[69.25,76.9,69.65,74.15]],['C',[70,71.45,71.5,69.45]],['C',[72.95,67.5,76.05,67.4]],['C',[79,67.5,80.3,69.65]],['C',[81.65,71.75,82,74.55]],['L',[82.3,79.45]],['L',[81.95,84.35]],['M',[85.85,62.6]],['C',[82.25,59.95,76.05,59.9]],['C',[70.25,59.95,66.45,62.5]],['C',[62.7,65.05,60.9,69.4]],['C',[59.1,73.7,59.1,79.2]],['C',[59.05,84.75,60.65,89.2]],['C',[62.2,93.65,65.8,96.25]],['C',[69.5,98.85,75.6,98.9]],['C',[81.4,98.85,85.15,96.35]],['C',[88.9,93.8,90.65,89.45]],['C',[92.5,85.1,92.5,79.65]],['C',[92.55,74.05,90.95,69.6]],['C',[89.45,65.2,85.85,62.6]],['M',[66.8,25.3]],['L',[25.4,99.7]],['L',[34.1,99.7]],['L',[75.3,25.3]],['L',[66.8,25.3]],['M',[9.35,35.95]],['C',[7.5,40.4,7.5,45.95]],['C',[7.45,51.45,9.1,55.8]],['C',[10.65,60.1,14.25,62.6]],['C',[17.9,65.1,24,65.15]],['C',[29.85,65.1,33.6,62.7]],['C',[37.35,60.25,39.1,56.05]],['C',[40.9,51.8,40.9,46.35]],['C',[40.95,40.75,39.4,36.15]],['C',[37.9,31.65,34.3,28.9]],['C',[30.65,26.2,24.5,26.1]],['C',[18.7,26.15,14.9,28.85]],['C',[11.15,31.5,9.35,35.95]],['M',[18.05,40.85]],['C',[18.45,38,19.9,35.85]],['C',[21.4,33.75,24.5,33.65]],['C',[26.7,33.7,28,35.05]],['C',[29.25,36.4,29.85,38.45]],['C',[30.4,40.5,30.55,42.6]],['L',[30.7,46.25]],['L',[30.35,51]],['C',[30,53.65,28.55,55.6]],['C',[27.15,57.5,24.1,57.6]],['C',[21,57.5,19.65,55.6]],['C',[18.25,53.65,17.95,51]],['L',[17.7,46.15]],['C',[17.7,43.75,18.05,40.85]]];
			__motifs["&"] = [['M',[40.85,27.25]],['C',[36.45,25.3,31,25.3]],['C',[26.15,25.35,21.95,27.35]],['C',[17.7,29.35,15.15,32.95]],['C',[12.5,36.6,12.4,41.6]],['C',[12.45,46.2,14.35,49.75]],['C',[16.25,53.35,19.2,56.8]],['C',[14.95,58.75,11.35,61.65]],['C',[7.7,64.6,5.5,68.55]],['C',[3.25,72.5,3.2,77.5]],['C',[3.25,84.25,6.35,89.05]],['C',[9.4,93.85,14.6,96.4]],['C',[19.8,98.85,26.3,98.9]],['C',[32.3,98.9,37.25,96.75]],['C',[42.15,94.6,46.4,90.4]],['L',[52.2,97.5]],['L',[69.6,97.5]],['L',[55.1,80.6]],['C',[58.05,76.8,59.75,72.3]],['C',[61.45,67.8,61.95,63]],['L',[49.7,63]],['L',[48.8,67.35]],['L',[47.05,71.45]],['L',[37.9,60.2]],['C',[43.4,57.35,46.9,52.95]],['C',[50.5,48.6,50.6,42.35]],['C',[50.55,36.75,47.9,32.95]],['C',[45.25,29.15,40.85,27.25]],['M',[36.05,47.7]],['C',[34,49.95,30.9,51.8]],['C',[28.75,49.4,27.1,46.9]],['C',[25.4,44.4,25.3,41.1]],['C',[25.4,38.25,27.2,36.55]],['C',[29.05,34.85,31.7,34.8]],['C',[34.4,34.85,36.25,36.8]],['C',[38.1,38.75,38.2,41.6]],['C',[38.1,45.4,36.05,47.7]],['M',[26.7,66]],['L',[38.85,80.9]],['C',[36.45,83.75,33.55,85.45]],['C',[30.65,87.15,26.9,87.2]],['C',[24.15,87.2,21.85,85.95]],['C',[19.55,84.65,18.15,82.55]],['C',[16.75,80.4,16.7,77.8]],['C',[16.75,74.9,18.15,72.65]],['C',[19.65,70.4,21.9,68.75]],['C',[24.15,67.1,26.7,66]]];
			__motifs["'"] = [['M',[8.6,26.1]],['L',[8.6,58.2]],['L',[19.3,58.2]],['L',[19.3,26.1]],['L',[8.6,26.1]]];
			__motifs["("] = [['M',[18.35,24.4]],['C',[13.95,30.85,11.05,38.75]],['C',[8.1,46.6,6.65,54.9]],['C',[5.2,63.15,5.2,70.7]],['C',[5.2,82.45,8.7,93.95]],['C',[12.15,105.4,18.35,115.7]],['L',[30.2,115.7]],['C',[24.65,104.85,22,93.25]],['C',[19.4,81.6,19.4,69.7]],['C',[19.4,58.05,22.05,46.5]],['C',[24.75,35.05,30.25,24.4]],['L',[18.35,24.4]]];
			__motifs[")"] = [['M',[11.25,24.4]],['L',[-0.6,24.4]],['C',[4.95,35.35,7.55,46.95]],['C',[10.2,58.65,10.2,70.5]],['C',[10.2,82.2,7.5,93.7]],['C',[4.85,105.15,-0.7,115.7]],['L',[11.25,115.7]],['C',[15.65,109.3,18.55,101.45]],['C',[21.5,93.55,22.95,85.3]],['C',[24.4,77.05,24.4,69.5]],['C',[24.35,57.75,20.9,46.25]],['C',[17.45,34.75,11.25,24.4]]];
			__motifs["*"] = [['M',[16.2,38.6]],['L',[4.9,34.2]],['L',[2.2,41.95]],['L',[13.75,45.85]],['L',[6.4,55.6]],['L',[13.1,60.55]],['L',[20.05,50.25]],['L',[27.5,60.55]],['L',[34.1,55.6]],['L',[26.65,45.85]],['L',[38.5,41.95]],['L',[35.8,34.2]],['L',[24.15,38.6]],['L',[24.15,26.1]],['L',[16.2,26.1]],['L',[16.2,38.6]]];
			__motifs["+"] = [['M',[24.7,47]],['L',[24.7,66.9]],['L',[4.85,66.9]],['L',[4.85,77.6]],['L',[24.7,77.6]],['L',[24.7,97.5]],['L',[35.4,97.5]],['L',[35.4,77.6]],['L',[55.25,77.6]],['L',[55.25,66.9]],['L',[35.4,66.9]],['L',[35.4,47]],['L',[24.7,47]]];
			__motifs[","] = [['M',[6.1,97.5]],['L',[13.35,97.5]],['C',[13.4,100.9,11.45,103.6]],['C',[9.4,106.25,6.2,106.9]],['L',[6.2,114.1]],['C',[10.55,113.4,14.05,111.25]],['C',[17.6,109.05,19.7,105.6]],['C',[21.8,102.1,21.85,97.5]],['L',[21.85,82.1]],['L',[6.1,82.1]],['L',[6.1,97.5]]];
			__motifs["-"] = [['M',[5.3,76.3]],['L',[35.4,76.3]],['L',[35.4,64.1]],['L',[5.3,64.1]],['L',[5.3,76.3]]];
			__motifs["."] = [['M',[6,97.5]],['L',[21.75,97.5]],['L',[21.75,82.1]],['L',[6,82.1]],['L',[6,97.5]]];
			__motifs["/"] = [['M',[26.75,24.4]],['L',[-1.1,99.2]],['L',[10.3,99.2]],['L',[38.2,24.4]],['L',[26.75,24.4]]];
			__motifs[":"] = [['M',[6.1,46.7]],['L',[6.1,62.1]],['L',[21.85,62.1]],['L',[21.85,46.7]],['L',[6.1,46.7]],['M',[6.1,97.5]],['L',[21.85,97.5]],['L',[21.85,82.1]],['L',[6.1,82.1]],['L',[6.1,97.5]]];
			__motifs[";"] = [['M',[6.1,46.7]],['L',[6.1,62.1]],['L',[21.85,62.1]],['L',[21.85,46.7]],['L',[6.1,46.7]],['M',[6.1,97.5]],['L',[13.35,97.5]],['C',[13.4,100.9,11.45,103.6]],['C',[9.4,106.25,6.2,106.9]],['L',[6.2,114.1]],['C',[10.55,113.4,14.05,111.25]],['C',[17.6,109.05,19.65,105.6]],['C',[21.75,102.1,21.85,97.5]],['L',[21.85,82.1]],['L',[6.1,82.1]],['L',[6.1,97.5]]];
			__motifs["<"] = [['M',[4.6,78.1]],['L',[55.35,98.35]],['L',[55.35,86.8]],['L',[18.7,72.2]],['L',[55.35,57.6]],['L',[55.35,46.15]],['L',[4.6,66.35]],['L',[4.6,78.1]]];
			__motifs["="] = [['M',[4.8,88.3]],['L',[55.25,88.3]],['L',[55.25,77.65]],['L',[4.8,77.65]],['L',[4.8,88.3]],['M',[4.8,66.9]],['L',[55.25,66.9]],['L',[55.25,56.2]],['L',[4.8,56.2]],['L',[4.8,66.9]]];
			__motifs[">"] = [['M',[4.6,98.35]],['L',[55.35,78.1]],['L',[55.35,66.35]],['L',[4.6,46.15]],['L',[4.6,57.6]],['L',[41.25,72.2]],['L',[4.6,86.8]],['L',[4.6,98.35]]];
			__motifs["?"] = [['M',[47,31.2]],['C',[44.15,28.2,39.35,26.35]],['C',[34.55,24.45,27.5,24.4]],['C',[20.15,24.45,14.8,27.65]],['C',[9.4,30.8,6.4,36.35]],['C',[3.4,41.9,3.2,49.1]],['L',[17.9,49.1]],['C',[17.95,45.5,19.05,42.55]],['C',[20.1,39.65,22.35,37.95]],['C',[24.6,36.15,28.15,36.1]],['C',[32.2,36.1,34.4,38.3]],['C',[36.6,40.55,36.65,45.1]],['C',[36.55,49.05,34.45,51.35]],['C',[32.4,53.7,29.4,55.9]],['C',[27.35,57.4,25.5,59.4]],['C',[23.65,61.4,22.3,64.35]],['C',[21.05,67.3,20.7,71.6]],['L',[20.7,76.1]],['L',[34.2,76.1]],['L',[34.2,72.3]],['C',[34.65,69.4,36.2,67.35]],['C',[37.65,65.3,39.75,63.75]],['C',[41.8,62.2,44,60.65]],['L',[48.05,56.9]],['C',[49.95,54.8,51.15,51.65]],['C',[52.35,48.55,52.4,43.7]],['C',[52.4,40.75,51.15,37.45]],['C',[49.9,34.1,47,31.2]],['M',[19.3,97.5]],['L',[35,97.5]],['L',[35,82.1]],['L',[19.3,82.1]],['L',[19.3,97.5]]];
			__motifs["@"] = [['M',[52.45,48.45]],['C',[50.6,44.55,47.3,42.95]],['C',[44.05,41.35,40.7,41.4]],['C',[35.75,41.45,31.75,43.6]],['C',[27.75,45.8,24.85,49.45]],['C',[21.95,53.05,20.45,57.6]],['C',[18.9,62.15,18.9,66.95]],['C',[18.95,71.6,21.05,75.5]],['C',[23.15,79.35,26.7,81.65]],['C',[30.25,83.95,34.6,84]],['C',[37.8,84,40.65,82.6]],['C',[43.55,81.2,45.4,78.2]],['L',[45.6,78.2]],['C',[45.8,80.7,47.75,82.25]],['C',[49.7,83.85,52.95,83.9]],['C',[55.4,83.9,59.3,82.25]],['C',[63.15,80.6,67.05,77.1]],['C',[71,73.6,73.65,68.1]],['C',[76.3,62.6,76.4,54.85]],['C',[76.35,48,73.55,42.35]],['C',[70.7,36.75,65.8,32.75]],['C',[61,28.75,54.75,26.6]],['C',[48.5,24.45,41.6,24.4]],['C',[33.8,24.45,26.9,27.3]],['C',[20.05,30.1,14.85,35.2]],['C',[9.55,40.25,6.65,47.05]],['C',[3.65,53.85,3.6,61.8]],['C',[3.75,72.6,8.9,81]],['C',[14,89.4,22.65,94.3]],['C',[31.35,99.1,42.15,99.2]],['C',[51.6,99.15,59.5,94.95]],['C',[67.45,90.75,72.6,83]],['L',[64.2,83]],['C',[60.25,86.9,54.7,89.05]],['C',[49.05,91.2,42.7,91.2]],['C',[34.05,91.15,27.45,87.55]],['C',[20.8,83.9,17.05,77.35]],['C',[13.3,70.8,13.25,62]],['C',[13.3,53.45,16.75,46.8]],['C',[20.2,40.2,26.55,36.3]],['C',[32.85,32.5,41.5,32.4]],['C',[49.2,32.4,55.3,35.25]],['C',[61.4,38.1,64.95,43.55]],['C',[68.55,49,68.6,56.95]],['C',[68.55,62.4,66.8,66.5]],['C',[65.1,70.65,62.4,73]],['C',[59.7,75.35,56.85,75.4]],['C',[55.6,75.35,55.3,74.25]],['C',[55,73.25,55.2,71.7]],['L',[55.9,68.8]],['L',[62.2,43]],['L',[54,43]],['L',[52.45,48.45]],['M',[30.7,58.9]],['C',[32.3,55.5,35.1,53.25]],['C',[37.9,51,41.5,50.9]],['C',[44.8,50.95,46.95,53.3]],['C',[49.1,55.65,49.2,59.4]],['C',[49.2,62.95,47.65,66.4]],['C',[46.05,69.8,43.3,72.1]],['C',[40.55,74.4,36.9,74.5]],['C',[33.4,74.45,31.3,72.05]],['C',[29.15,69.65,29.1,65.6]],['C',[29.15,62.2,30.7,58.9]]];
			__motifs["["] = [['M',[6.8,24.4]],['L',[6.8,115.7]],['L',[33.2,115.7]],['L',[33.2,104.55]],['L',[21,104.55]],['L',[21,35.6]],['L',[33.2,35.6]],['L',[33.2,24.4]],['L',[6.8,24.4]]];
			__motifs["\\"] = [['M',[38.2,99.2]],['L',[10.3,24.4]],['L',[-1.1,24.4]],['L',[26.75,99.2]],['L',[38.2,99.2]]];
			__motifs["]"] = [['M',[12.3,35.6]],['L',[12.3,104.55]],['L',[0.1,104.55]],['L',[0.1,115.7]],['L',[26.5,115.7]],['L',[26.5,24.4]],['L',[0.1,24.4]],['L',[0.1,35.6]],['L',[12.3,35.6]]];
			__motifs["^"] = [['M',[23.3,27.5]],['L',[6.1,66]],['L',[17.8,66]],['L',[30,38.45]],['L',[42.2,66]],['L',[53.9,66]],['L',[36.7,27.5]],['L',[23.3,27.5]]];
			__motifs["_"] = [['M',[50,105]],['L',[0,105]],['L',[0,110]],['L',[50,110]],['L',[50,105]]];
			__motifs["`"] = [['M',[10.9,25.2]],['L',[-4.8,25.2]],['L',[10.6,39.4]],['L',[20.5,39.4]],['L',[10.9,25.2]]];
		}

		static private function initializeWidthsUppercase():void {
			__widths["A"] = 69;
			__widths["B"] = 70;
			__widths["C"] = 74;
			__widths["D"] = 74;
			__widths["E"] = 65;
			__widths["F"] = 59;
			__widths["G"] = 76;
			__widths["H"] = 74;
			__widths["I"] = 30;
			__widths["J"] = 56;
			__widths["K"] = 72;
			__widths["L"] = 59;
			__widths["M"] = 91;
			__widths["N"] = 74;
			__widths["O"] = 78;
			__widths["P"] = 67;
			__widths["Q"] = 78;
			__widths["R"] = 72;
			__widths["S"] = 65;
			__widths["T"] = 61;
			__widths["U"] = 74;
			__widths["V"] = 63;
			__widths["W"] = 94;
			__widths["X"] = 67;
			__widths["Y"] = 67;
			__widths["Z"] = 65;
		}

		static private function initializeWidthsLowercase():void {
			__widths["a"] = 57;
			__widths["b"] = 61;
			__widths["c"] = 57;
			__widths["d"] = 61;
			__widths["e"] = 57;
			__widths["f"] = 33;
			__widths["g"] = 61;
			__widths["h"] = 59;
			__widths["i"] = 26;
			__widths["j"] = 28;
			__widths["k"] = 57;
			__widths["l"] = 26;
			__widths["m"] = 91;
			__widths["n"] = 59;
			__widths["o"] = 61;
			__widths["p"] = 61;
			__widths["q"] = 61;
			__widths["r"] = 39;
			__widths["s"] = 54;
			__widths["t"] = 35;
			__widths["u"] = 59;
			__widths["v"] = 52;
			__widths["w"] = 81;
			__widths["x"] = 54;
			__widths["y"] = 52;
			__widths["z"] = 52;
		}

		static private function initializeWidthsNumbers():void {
			__widths["0"] = 56;
			__widths["1"] = 56;
			__widths["2"] = 56;
			__widths["3"] = 56;
			__widths["4"] = 56;
			__widths["5"] = 56;
			__widths["6"] = 56;
			__widths["7"] = 56;
			__widths["8"] = 56;
			__widths["9"] = 56;
		}

		static private function initializeWidthsPunctuation():void {
			__widths[" "] = 28;
			__widths["!"] = 28;
			__widths["\""] = 37;
			__widths["#"] = 56;
			__widths["$"] = 56;
			__widths["%"] = 100;
			__widths["&"] = 69;
			__widths["'"] = 28;
			__widths["("] = 30;
			__widths[")"] = 30;
			__widths["*"] = 41;
			__widths["+"] = 60;
			__widths[","] = 28;
			__widths["-"] = 41;
			__widths["."] = 28;
			__widths["/"] = 37;
			__widths[":"] = 28;
			__widths[";"] = 28;
			__widths["<"] = 60;
			__widths["="] = 60;
			__widths[">"] = 60;
			__widths["?"] = 56;
			__widths["@"] = 80;
			__widths["["] = 33;
			__widths["\\"] = 37;
			__widths["]"] = 33;
			__widths["^"] = 60;
			__widths["_"] = 50;
			__widths["`"] = 26;
		}

	}

}